#!/bin/bash
##Проверка системы на готовность

#ABSOLUTE_PATH="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)" \
#cd $ABSOLUTE_PATH \
#$ABSOLUTE_PATH

echo "      #################################################
      Внимание!
      Запускается скрипт обновления терминала CyberFT !
      #################################################";
      sleep 5;

if [ -f ./update.log ]; then
     echo "Найден старый лог, чистим"
     chmod 777 ./update.log
     echo -n "" > ./update.log
     echo "Начинаем логирование обновления"
     exec > >(tee -i update.log)
else
    echo "Создание update лога"
    touch ./update.log && chmod 777 ./update.log
    echo "Начинаем логирование обновления"
    exec > >(tee -i ./update.log)
fi

#Проверка root
if [ "$(whoami)" != 'root' ] ; then
	echo "Скрипт обновления необходимо запускать от root-пользователя!";
	echo "Аварийное завершение";
	exit 1;
fi


#Проверка докера
if [ `which docker | wc -l` -eq 1 ]; then
   echo "Обновление docker-engine";
   rm -rf /etc/apt/sources.list.d/docker.list;
   echo "deb [arch=amd64] https://apt.dockerproject.org/repo debian-jessie main" >> /etc/apt/sources.list.d/docker.list;
   apt-get -y update;
   apt-get install docker-engine
else
   echo "Локальная установка"
   apt-get -y update;
   apt-get -y upgrade;
fi

if [ `which curl | wc -l` -eq 1 ]; then
   echo "Устанавливаем curl";
   apt-get -y update;
   apt-get install curl
fi

#Проверка места
echo "Проверка свободного места на жестком диске"
echo "Это Необходимо для разворачивания docker-engine"
FREESIZE=80
DOCKER=`docker ps -q`
DEST=`docker inspect $DOCKER | grep '/app' | sed q | cut -d '"' -f 2 | cut -d ":" -f 1 `
USED=`df -h $DEST | sed -n -e 2p | cut -d 'G' -f 4 | cut -d '/' -f 1 | cut -d '%' -f 1`
echo "Занятое пространство: $USED% "
if [ $USED -le $FREESIZE  ]; then
    echo "Места хватает"
    echo "Продолжнаем установку"
else
    echo "Внимание! У вас занято больше 80% места на диске!"
    echo "Освободите место!"
    echo "Аварийное завершение"
    exit 1;
fi

#Проверка доступа к нашему репозиторию, парсинг, скачивание
echo "Проверка корретного соединения с репозиторием CyberFT"
wget -P /tmp http://download.cyberft.ru/CyberFT%203.2/ > /dev/null 2>&1
if [ $? -ne 0 ]; then
    echo "Ошибка! Отсутствует доступ в интернет для протокола http. Невозможно скачать файл обновления!"
    exit;
else
    echo "Доступ к репозиторию CyberFT найден. Скачиваем файл обновления!"
    version=`curl http://download.cyberft.ru/CyberFT%203.2/ -silent | grep '<a href="cyberft-v' | iconv -f WINDOWS-1251 -t UTF-8 | sed -n -e 1p | cut -d '"' -f 2`
    echo "Текущая версия - $version"
    echo "Скачиваем версию - $version , не закрывайте и не отменяйте данное окно."
    wget http://download.cyberft.ru/CyberFT%203.2/$version > /dev/null 2>&1
    echo "$version скачалась"
fi


#Распаковка, установка
echo "Распаковываем архив"
rm -rf ./update > /dev/null 2>&1
mkdir ./update && tar xvf "$version" -C ./update
cp ./autoupdate.sh ./update/distr/autoupdate.sh
OLD="$DEST/../"
PREV_INSTALL_DIR=$OLD ./update/distr/autoupdate.sh
. ./update/distr/autoupdate.sh
rm -rf $version && rm -rf ./update


