#!/bin/bash
ABSOLUTE_PATH="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd $ABSOLUTE_PATH

if [ -f update.log ]; then 
    rm -f update.log
fi

# Mandatory copying output to log file
exec > >(tee -i update.log)

source inc/vars.sh
source inc/functions.sh

checkroot

if [ ! -f  $PREV_INSTALL_DIR/app/.env ]; then
    error "Cannot detect application in specified directory. Applying safe update scenario."
	if ask "Did you use Docker during install?"; then
		source update/safe-update.sh
	else
		source update/safe-direct-update.sh
	fi
else
	. $PREV_INSTALL_DIR/app/.env
	if [ "$INSTALL_TYPE" == "docker" ]; then
		source update/docker-update.sh
	else
		source update/direct-update.sh
	fi
fi
